#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.DlgSelectSpecificities;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_Reagent : BaseTest 
	{

		private Reagent _tstReagent;
		private ReagentChange _tstReagentChange;
		private DataTable dtReagent; 
		private DataTable dtRackLot; 

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				string sSQL = "SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode='A' ";

				dtReagent = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

				sSQL = "SELECT TOP 1 * FROM Reagent JOIN RackLot ON RackLot.ReagentGuid=Reagent.ReagentGuid JOIN Rack ON Rack.RackGuid = RackLot.RackGuid WHERE Reagent.InvoiceNumber IS NOT NULL AND Rack.RecordStatusCode = 'A' AND Reagent.RecordStatusCode = 'A'";

				dtRackLot=UnitTestUtil.RunSQLGetDataTable(sSQL, true);

				this.RefreshData = false;
			}

			_tstReagent = new gov.va.med.vbecs.BOL.Reagent();
			_tstReagent.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.Reagent);

			_tstReagentChange = new gov.va.med.vbecs.BOL.ReagentChange();
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(!_tstReagent.Equals(null));
			Assert.AreEqual(_tstReagent,_tstReagent);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			_tstReagent.ReagentGuid = Guid.NewGuid();
			DataTable dtReagents = Reagent.GetReagents(this.TestDivisionCode);
			if (dtReagents.Rows.Count > 0)
			{
				_tstReagent = new Reagent(dtReagents.Rows[0]);
				Assert.AreEqual((Guid)dtReagents.Rows[0][TABLES.Reagent.ReagentGuid], _tstReagent.ReagentGuid);
			}
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void Ctor_DataRow_Fail()
		{
			_tstReagent = new Reagent( (DataRow)null );
			Assert.IsNull( _tstReagent );
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.Reagent tmpReagent=new BOL.Reagent((System.Guid)this.dtReagent.Rows[0][TABLES.Reagent.ReagentGuid]);

			Assert.IsNotNull(tmpReagent);
			Assert.AreEqual(tmpReagent.ReagentGuid, (System.Guid)this.dtReagent.Rows[0][TABLES.Reagent.ReagentGuid]);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void GetReagentByGuid_Pass()
		{
			DataRow drReagent=BOL.Reagent.GetReagent((System.Guid)this.dtReagent.Rows[0][TABLES.Reagent.ReagentGuid]);

			Assert.IsNotNull(drReagent);
		}
		
		[Test]
		public void GetReagentByGuid_Fail()
		{
			DataRow drReagent=BOL.Reagent.GetReagent(System.Guid.Empty);

			for(int i=0; i<drReagent.Table.Columns.Count; i++)
			{
				Assert.AreEqual( drReagent[i].ToString() , String.Empty );
			}
		}

		[Test]
		public void GetReagentFromRack_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 RE.ReagentTypeId, R.RackGuid FROM dbo.Reagent RE JOIN dbo.RackLot RL ON RL.ReagentGuid = RE.ReagentGuid JOIN dbo.Rack R ON R.RackGuid = RL.RackGuid WHERE R.RecordStatusCode = 'A' AND R.DivisionCode = '"+UnitTestConfig.TestDivisionCode+"'");
			DataTable dtReagentFromRack=BOL.Reagent.GetReagentFromRack((System.Guid)dr[TABLES.RackLot.RackGuid],Convert.ToInt32(dr[TABLES.Reagent.ReagentTypeId]), this.TestDivisionCode);

			Assert.IsNotNull(dtReagentFromRack);
			Assert.IsTrue(dtReagentFromRack.Rows.Count>0);
		}
		
		[Test]
		public void GetReagentFromRack_Fail()
		{
			DataTable dtReagentFromRack=BOL.Reagent.GetReagentFromRack(System.Guid.Empty,(int)Common.ReagentType.AntiAB, String.Empty);

			Assert.IsTrue(dtReagentFromRack.Rows.Count<1);
		}

		[Test]
		public void ReagentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstReagent.ReagentGuid = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.ReagentGuid);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentGuid_Fail()
		{
		}

		[Test]
		public void ReagentName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstReagent.ReagentName = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.ReagentName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentName_Fail()
		{
		}

		[Test]
		public void ReceiptDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstReagent.ReceiptDate = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.ReceiptDate);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReceiptDate_Fail()
		{
		}

		[Test]
		public void LotNumber_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstReagent.LotNumber = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.LotNumber, "Value");
			Assert.AreEqual(false, this._tstReagent.IsRuleBroken(BROKEN.LotNumber), "BrokenRule");
		}

		
		[Test]
		public void LotNumber_Fail()
		{
			string tstValue = string.Empty;

			this._tstReagent.LotNumber = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.LotNumber, "Value");
			Assert.AreEqual(true, this._tstReagent.IsRuleBroken(BROKEN.LotNumber), "BrokenRule");

		}

		[Test]
		public void LotExpirationDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstReagent.LotExpirationDate = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.LotExpirationDate);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LotExpirationDate_Fail()
		{
		}


		[Test]
		public void NumberVialsReceived_Pass()
		{
			short tstValue = (short)new Random().Next(1,99);

			this._tstReagent.NumberVialsReceived = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.NumberVialsReceived);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void NumberVialsReceived_Fail()
		{
		}

		[Test]
		public void NumberVialsAvailable_Pass()
		{
			short tstValue = (short)new Random().Next(1,99);

			this._tstReagent.NumberVialsAvailable = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.NumberVialsAvailable);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void NumberVialsAvailable_Fail()
		{
		}

		[Test]
		public void ReagentType_Pass()
		{
			BOL.ReagentType tstValue = new BOL.ReagentType();

			this._tstReagent.ReagentType = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.ReagentType);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentType_Fail()
		{
		}

		[Test]
		public void ReagentManufacturerName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstReagent.ReagentManufacturerName = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.ReagentManufacturerName);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentManufacturerName_Fail()
		{
		}

		[Test]
		public void InspectionIndicator_Pass()
		{
			bool tstValue = (!this._tstReagent.InspectionIndicator);

			this._tstReagent.InspectionIndicator = tstValue;

			Assert.AreEqual(tstValue, this._tstReagent.InspectionIndicator);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InspectionIndicator_Fail()
		{
		}


		[Test]
		public void GetReagents_Pass()
		{
			DataTable dtRetVal = Reagent.GetReagents(this.TestDivisionCode);
			Assert.IsTrue(dtRetVal != null);
		}

		[Test]
		public void GetReagents_Fail()
		{
			DataTable dtRetVal = Reagent.GetReagents("");
			Assert.IsTrue(dtRetVal.Rows.Count == 0);
		}

		[Test]
		public void GetReagentsByDate_Pass()
		{
			DataTable dtRetVal = Reagent.GetReagents(this.TestDivisionCode, DateTime.MaxValue, DateTime.MinValue, DateTime.MaxValue, DateTime.MinValue);
			Assert.IsNotNull( dtRetVal );
			Assert.IsTrue( dtRetVal.Rows.Count > 0 );
		}

		[Test]
		public void GetReagentsByDate_Fail()
		{
			DataTable dtRetVal = Reagent.GetReagents(String.Empty,DateTime.Today.AddYears(-1), DateTime.Today, DateTime.Today.AddYears(-1), DateTime.Today );
			Assert.AreEqual(dtRetVal.Rows.Count, 0);
		}

		[Test]
		public void InitializeReagentsAndManufacturersTable_Pass()
		{
			DataTable dtRetVal = Reagent.InitializeReagentsAndManufacturersTable();
			Assert.IsTrue(dtRetVal.Columns.Count > 0);
			Assert.IsTrue(dtRetVal.TableName == "Reagents");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeReagentsAndManufacturersTable_Fail()
		{
		}

		[Test]
		public void InsertNewReagent_Pass()
		{
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			DataTable dtReagentTypes = ReagentType.GetReagentTypes();

			if (dtReagentTypes.Rows.Count > 0)
			{
				drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
				drReagent[TABLES.ReagentType.ReagentTypeId] = dtReagentTypes.Rows[0][TABLES.ReagentType.ReagentTypeId];
				drReagent["ReagentName"] = "Test Reagent";
				drReagent["ReceiptDate"] = DateTime.Now;
				drReagent["ReceiptTechId"] = "VHAISHDobraK";
				drReagent["InvoiceNumber"] = "1234567";
				drReagent[TABLES.Reagent.LotNumber] = "L987532";
				drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now;
				drReagent["NumberVialsReceived"] = 20;
				drReagent["NumberVialsAvailable"] = 15;
				drReagent["Comments"] = "Testing _tstReagent insert";
				drReagent["InspectionIndicator"] = true;
				drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
				drReagent["ReagentTypeName"] = dtReagentTypes.Rows[0]["ReagentTypeName"];
				drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
				drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
				dtReagents.Rows.Add(drReagent);

				Assert.IsTrue(Reagent.InsertNewReagent(dtReagents, dtReagentTypes, Common.UpdateFunction.UnitTests));
			}
		}

		[Test]
		public void InsertNewReagent_Fail()
		{
			DataTable dtReagents = new DataTable();
			Assert.IsTrue(Reagent.InsertNewReagent(dtReagents, new DataTable(), Common.UpdateFunction.UnitTests) == false);
		}

		[Test]
		public void UpdateReagent_Pass()
		{
			this.RefreshData = true;

			DataTable dtReagents = Reagent.GetReagents(this.TestDivisionCode);
			if (dtReagents.Rows.Count > 0)
			{
				_tstReagent = new Reagent(dtReagents.Rows[0]);
				_tstReagentChange.ReagentChangeGuid = Guid.NewGuid();
				_tstReagentChange.ReagentGuid = _tstReagent.ReagentGuid;
				_tstReagentChange.ReagentChangeDetailCode = "O";
				_tstReagentChange.Comments = "Testing _tstReagent update";
				_tstReagentChange.LastUpdateDate = DateTime.Now;
				Assert.IsTrue(_tstReagent.UpdateReagent(_tstReagentChange,dtReagents, Common.UpdateFunction.UnitTests));
			}
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void UpdateReagent_Fail()
		{
			this.RefreshData = true;
			
			_tstReagentChange = new ReagentChange();
			_tstReagentChange.LastUpdateDate = DateTime.Now;
			_tstReagent.RowVersion = new byte[8];

			bool updated = _tstReagent.UpdateReagent(_tstReagentChange, new DataTable(), Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetReagentManufacturers_Pass()
		{
			DataTable dtRetVal = Reagent.GetReagentManufacturers();
			Assert.IsTrue(dtRetVal != null);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReagentManufacturers_Fail()
		{
		}


		[Test]
		public void GetManufacturerReagentNames_Pass()
		{
			string sManufacturerName = "Ortho-Clinical Diagnostics, Inc.";
//			Common.LogonUser.LogonUserDivisionCode = _tstReagent.DivisionCode;
			DataTable dtRetVal = Reagent.GetManufacturerReagentNames(sManufacturerName);
			Assert.IsTrue(dtRetVal != null);
		}

		[Test]
		public void GetManufacturerReagentNames_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			DataTable dtRetVal = Reagent.GetManufacturerReagentNames("");
			Assert.IsTrue(dtRetVal.Rows.Count == 0);
		}

		[Test]
		public void GetReagentTypeStockLevel_Pass()
		{
			Common.LogonUser.LogonUserDivisionCode = this.TestDivisionCode;
			_tstReagent.ReagentType.ReagentTypeId = 48;
			Assert.IsTrue(_tstReagent.GetReagentTypeStockLevel() >= 0);
		}

		[Test]
		public void GetReagentTypeStockLevel_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			_tstReagent.ReagentType.ReagentTypeId = -1;
			Assert.IsTrue(_tstReagent.GetReagentTypeStockLevel() == -1);
		}

		[Test]
		public void GetReagentsByType_Pass()
		{
			DataTable dtReagents = Reagent.GetReagentsByType(this.TestDivisionCode, 48);
			Assert.IsTrue(dtReagents != null);
		}

		[Test]
		public void GetReagentsByType_Fail()
		{
			DataTable dtReagents = Reagent.GetReagentsByType("", -1);
			Assert.IsTrue(dtReagents.Rows.Count == 0);
		}

		[Test]
		public void GetReagentLotsForRetest_Pass()
		{
			Common.LogonUser.LogonUserDivisionCode = this.TestDivisionCode;
			DataTable dtRacks = DAL.Rack.GetDailyQCRacks(BOL.VBECSDateTime.GetDivisionCurrentDateTime());
			if (dtRacks.Rows.Count > 0)
			{
				DataTable dtRetVal = Reagent.GetReagentLotsForRetest((Guid)dtRacks.Rows[0][TABLES.Rack.RackGuid]);
				Assert.IsTrue(dtRetVal != null);
			}
		}

		[Test]
		public void GetReagentLotsForRetest_Fail()
		{
				DataTable dtRetVal = Reagent.GetReagentLotsForRetest(Guid.NewGuid());
				Assert.IsTrue(dtRetVal.Rows.Count == 0);
		}

		[Test]
		public void GetReagentLotsFromPreviousTest_Pass()
		{
			Common.LogonUser.LogonUserDivisionCode = this.TestDivisionCode;
			DataTable dtRetVal = Reagent.GetReagentLotsFromPreviousTest("A");
			Assert.IsTrue(dtRetVal != null);
		}

		[Test]
		public void GetReagentLotsFromPreviousTest_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			DataTable dtRetVal = Reagent.GetReagentLotsFromPreviousTest("");
			Assert.IsTrue(dtRetVal.Rows.Count == 0);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			_tstReagent.ReagentGuid = Guid.NewGuid();
			_tstReagent.RowVersion = new Byte[0];
			DataTable dtReagents = Reagent.GetReagents(this.TestDivisionCode);
			if (dtReagents.Rows.Count > 0)
			{
				DataRow drReagent = dtReagents.NewRow();
				drReagent = _tstReagent.LoadDataRowFromThis(drReagent);
				Assert.AreEqual((Guid)drReagent[TABLES.Reagent.ReagentGuid], _tstReagent.ReagentGuid);
			}
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail()
		{
			Reagent rgt = new Reagent( Guid.Empty );
			DataTable dt = new DataTable( "test" );
			dt.Columns.Add( Guid.Empty.ToString() );

			Assert.IsNull( rgt.LoadDataRowFromThis( dt.NewRow() ) );
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
			const string REAGENTCOLUMNS = "ReagentGuid,ReagentName,LotNumber,LotExpirationDate,"+
							"ReagentManufacturerName,InspectionIndicator";

			_tstReagent.ReagentGuid = Guid.NewGuid();
			DataTable dtReagents = Reagent.GetReagentsByType(this.TestDivisionCode, 48);

			Assert.IsTrue(_tstReagent.VerifyMinColumnsInDataTable(REAGENTCOLUMNS.Split(','), dtReagents));
		}

		
		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{
			const string REAGENTCOLUMNS = "ReagentGuid,ReagentName,LotNumber,LotExpirationDate, ReagentManufacturerName,InspectionIndicator";
			
			Assert.IsTrue(_tstReagent.VerifyMinColumnsInDataTable(REAGENTCOLUMNS.Split(','), new DataTable()) == false);
		}

		[Test]
		public void GetReagentsForInvoice_Pass()
		{
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("select top 1 * from reagent r join reagenttypeparameter rtp on rtp.reagenttypeid = r.reagenttypeid", false);

			if (dtData.Rows.Count == 0)
			{
				int reagentTypeId = new Random().Next(11,31);
				short minLevel = (short)new Random().Next(1,99);
				DAL.ReagentType.InsertReagent(reagentTypeId, minLevel, Common.UpdateFunction.UnitTests);

				System.Guid reagentGuid = System.Guid.NewGuid();
				DataTable dtTest = SprocHelper.GetInsertReagentSprocTable(reagentGuid, reagentTypeId);
				System.Guid [] reagentGuids = new Guid[1];
				reagentGuids[0] = reagentGuid;
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginReagent);
				DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginReagent, reagentGuids, Common.WorkloadTransactionType.Miscellanious, false);

				bool retValue = DAL.Reagent.InsertReagents(dtTest, dtWorkloadEvent, Common.UpdateFunction.UnitTests);

				dtData = UnitTestUtil.RunSQLGetDataTable("select top 1 * from reagent r join reagenttypeparameter rtp on rtp.reagenttypeid = r.reagenttypeid", false);
			}

			DataTable dtReagents = BOL.Reagent.GetReagentsForInvoice(dtData.Rows[0][TABLES.Reagent.InvoiceNumber].ToString());

			Assert.IsNotNull(dtReagents);
			Assert.IsTrue(dtReagents.Rows.Count>0);
		}
		
		[Test]
		public void GetReagentsForInvoice_Fail()
		{
			DataTable dtReagents=BOL.Reagent.GetReagentsForInvoice(String.Empty);

			Assert.IsTrue(dtReagents.Rows.Count<1);
		}
	}
}
#endif




